const express = require('express');
const router = express.Router();
const Inscricao = require('../models/Inscricao');

// Middleware de autenticação (simplificado)
const authMiddleware = (req, res, next) => {
  // Implemente sua lógica de autenticação aqui
  const isAuthenticated = true; // Exemplo simplificado
  
  if (isAuthenticated) {
    next();
  } else {
    res.redirect('/login');
  }
};

// Listar todas as inscrições
router.get('/', authMiddleware, async (req, res) => {
  try {
    const inscricoes = await Inscricao.listarTodos();
    res.render('admin/inscricoes', { inscricoes });
  } catch (error) {
    console.error('Erro ao listar inscrições:', error);
    res.status(500).send('Erro ao carregar inscrições');
  }
});

// Marcar inscrição como paga
router.post('/:id/pagar', authMiddleware, async (req, res) => {
  try {
    const { id } = req.params;
    const changes = await Inscricao.marcarComoPago(id);
    
    if (changes > 0) {
      res.json({ success: true });
    } else {
      res.status(404).json({ success: false, message: 'Inscrição não encontrada' });
    }
  } catch (error) {
    console.error('Erro ao marcar como pago:', error);
    res.status(500).json({ success: false, message: 'Erro ao atualizar inscrição' });
  }
});

module.exports = router;