const sqlite3 = require('sqlite3').verbose();
const path = require('path');

// Configuração do banco de dados SQLite
const dbPath = path.join(__dirname, 'inscricoes.db');

// Criar conexão com o banco de dados
const db = new sqlite3.Database(dbPath, (err) => {
  if (err) {
    console.error('Erro ao conectar ao banco de dados SQLite:', err.message);
  } else {
    console.log('Conectado ao banco de dados SQLite em:', dbPath);
    db.get("PRAGMA foreign_keys = ON");
  }
});

module.exports = db;