require('dotenv').config();
const express = require('express');
const path = require('path');
const bodyParser = require('body-parser');
const db = require('./database/db'); // Adicione esta linha

const app = express();

// Configurações
app.set('view engine', 'ejs');
app.set('views', path.join(__dirname, 'views'));

// Middlewares
app.use(express.static(path.join(__dirname, 'public')));
app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());

// Rotas
const webRoutes = require('./routes/web');
app.use('/', webRoutes);

// Rota para painel admin (opcional)
const adminRoutes = require('./routes/admin');
app.use('/admin', adminRoutes);

// Inicia o servidor
const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
  console.log(`Servidor rodando na porta ${PORT}`);
  
  // Verificar se a tabela existe (opcional)
  db.get("SELECT name FROM sqlite_master WHERE type='table' AND name='inscricoes'", (err, row) => {
    if (err) {
      console.error('Erro ao verificar tabela:', err);
    } else if (!row) {
      console.log('Tabela de inscrições não encontrada. Execute a migration.');
    }
  });
});